--
-- The following script creates 4.5.0 SQL Analysis Repository tables in a 
-- configuration suitable for medium collection sizes.
--
-- Directions for customizing this script:
--
-- 1. This script creates the SQL Analysis repository in two DMS tablespaces 
--    using file-based containers and one SMS tablespace. One DMS tablespace
--    is used for all basic SQL Collection repository tables. The second 
--    DMS tablespace is used for all basic SQL Collection repository
--    indexes. The SMS tablespace, which defaults to USERSPACE1, is used to
--    store all Extended Analysis and Adhoc Facility tables and indexes.
--
--    In addition, DDL is provided to create one system DMS tablespace for temporary 
--    tables.
-- 
--    If you want to use device-based containers, comment out the file container 
--    clause and then uncomment the device container clause in each CREATE TABLESPACE 
--    statement.
--
-- 2. Replace the @DATA_TS_LOC symbol with the name of the container to be used for 
--    the data-page tablespace that will store all SQL Analysis repository tables. 
--
-- 3. Replace the @DATA_PAGES symbol with the number of pages to allocate to 
--    the data-page tablespace that will store all SQL Analysis repository 
--    tables.
-- 
-- 4. Replace the @INDEX_TS_LOC symbol with the name of the container to be used for 
--    the index-page tablespace that will store all SQL Analysis repository 
--    indexes. 
--
-- 5. Replace the @INDEX_PAGES symbol with the number of pages to allocate to 
--    the index-page tablespace that will store all SQL Analysis repository 
--    indexes.
--
-- 6. Replace the @TEMP_TS_LOC symbol with the name of the container to be used for 
--    the system temporary tablespace. 
--
-- 7. Replace the @TEMP_PAGES symbol with the number of pages to allocate to 
--    the system temporary tablespace. Specify a number of pages equal to
--    1 GB of disk storage. 
--
-- 8. If the CREATE TABLESPACE statement needs to specify a node group or database 
--    partition group that is different from the default node group or partition for 
--    a tablespace, locate the @PARTITION symbol in each CREATE TABLESPACE statement 
--    and uncomment the appropriate line for the DB2 version that will store the 
--    repository.
--
-- 9. Replace each occurrence of the @SCREPO_DATA_TS symbol with the name of the 
--    SQL Analysis repository data-page tablespace that will store all SQL Analysis 
--    repository tables.
--
-- 10. Replace each occurrence the @SCREPO_INDEX_TS symbol with the name of the 
--     SQL Analysis repository index-page tablespace that will store all SQL Analysis
--     repository indexes.
--       
-- 11. Replace each occurrence of the @TEMP_TS symbol with the name of the system 
--     temporary tablespace to be used with the SQL Analysis repository.
--       
-- 12. Replace the @DATA_BP symbol with the name of the bufferpool that 
--     the SQL Analysis repository data-page tablespace and temporary 
--     tablespace will use.
-- 
-- 13. Replace the @INDEX_BP symbol with the name of the bufferpool that
--     the SQL Analysis repository index-page tablespace will use.
--

-- CREATE SQL ANALYSIS REPOSITORY TABLESPACES.
CREATE TABLESPACE @SCREPO_DATA_TS
  -- @PARTITION
  -- Uncomment the following line for V8.1:
  --IN DATABASE PARTITION GROUP IBMDEFAULTGROUP
  -- Uncomment the following line for V7.1:
  --IN NODEGROUP IBMDEFAULTGROUP
  PAGESIZE 32K
  MANAGED BY DATABASE 
  USING
   (
    File '@DATA_TS_LOC' @DATA_PAGES
 	-- Comment out the File line above, and uncomment the Device line if using device based containers.
 	--Device '@DATA_TS_LOC' @DATA_PAGES
   )
  EXTENTSIZE 32
  PREFETCHSIZE 128
  BUFFERPOOL @DATA_BP
  OVERHEAD 24.10
  TRANSFERRATE 0.90
  DROPPED TABLE RECOVERY OFF;

#SYNC 10;

CREATE TABLESPACE @SCREPO_INDEX_TS
  -- @PARTITION
  -- Uncomment the following line for V8.1:
  --IN DATABASE PARTITION GROUP IBMDEFAULTGROUP
  -- Uncomment the following line for V7.1:
  --IN NODEGROUP IBMDEFAULTGROUP
  PAGESIZE 32K
  MANAGED BY DATABASE 
  USING
   (
    File '@INDEX_TS_LOC' @INDEX_PAGES
 	-- Comment out the File line above, and uncomment the Device line if using device based containers.
 	--Device '@INDEX_TS_LOC' @INDEX_PAGES
   )
  EXTENTSIZE 32
  PREFETCHSIZE 64
  BUFFERPOOL @INDEX_BP
  OVERHEAD 24.10
  TRANSFERRATE 0.90
  DROPPED TABLE RECOVERY OFF;

#SYNC 20;

CREATE TEMPORARY TABLESPACE @TEMP_TS
  -- @PARTITION
  -- Uncomment the following line for V8.1:
  --IN DATABASE PARTITION GROUP IBMTEMPGROUP
  -- Uncomment the following line for V7.1:
  --IN NODEGROUP IBMTEMPGROUP
  PAGESIZE 32K
  MANAGED BY DATABASE 
  USING
   (
    File '@TEMP_TS_LOC' @TEMP_PAGES
 	-- Comment out the File line above, and uncomment the Device line if using device based containers.
    --Device '@TEMP_TS_LOC' @TEMP_PAGES
   )
  EXTENTSIZE 32
  PREFETCHSIZE 128
  BUFFERPOOL @DATA_BP
  OVERHEAD 24.10
  TRANSFERRATE 0.90
  DROPPED TABLE RECOVERY OFF;

#SYNC 25;

-- CREATE SQL ANALYSIS REPOSITORY TABLES.
CREATE TABLE QUEST.SC_COLDEP
 (SC_COLDEP_HOSTID  INTEGER                      NOT NULL,
  SC_COLDEP_TABID   INTEGER                      NOT NULL,
  SC_COLDEP_COLID   INTEGER                      NOT NULL,
  SC_COLDEP_PTRN    CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_COLDEP_SEQNO   INTEGER                      NOT NULL,
  SC_COLDEP_SPOS    SMALLINT                     NOT NULL,
  SC_COLDEP_SWHERE  SMALLINT                     NOT NULL,
  SC_COLDEP_USE1    SMALLINT                     NOT NULL,
  SC_COLDEP_USE2    SMALLINT                     NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 30;

ALTER TABLE QUEST.SC_COLDEP
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 40;

CREATE TABLE QUEST.SC_COLINFO
 (SC_CINFO_CKEY     INTEGER         NOT NULL,
  SC_CINFO_SUBCKEY  INTEGER         NOT NULL  DEFAULT 0,
  SC_CINFO_SEQNO    INTEGER         NOT NULL,
  SC_CINFO_TYPE     INTEGER         NOT NULL,
  SC_CINFO_DATA     VARCHAR(254)    NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;
  
#SYNC 50;

ALTER TABLE QUEST.SC_COLINFO
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 60;

CREATE TABLE QUEST.SC_COLLECTION
 (SC_COL_CKEY     INTEGER         NOT NULL,
  SC_COL_SUBCKEY  INTEGER         NOT NULL  DEFAULT 0,
  SC_COL_CREATOR  CHARACTER(18)   NOT NULL,
  SC_COL_NAME     CHARACTER(18)   NOT NULL,
  SC_COL_DBNAME   CHARACTER(18)   NOT NULL,
  SC_COL_MACHNE   VARCHAR(255)    NOT NULL,
  SC_COL_INSTAN   CHARACTER(8)    NOT NULL,
  SC_COL_START    TIMESTAMP       NOT NULL,
  SC_COL_END      TIMESTAMP       NOT NULL,
  SC_COL_DURATION INTEGER         NOT NULL,
  SC_COL_STATUS   CHARACTER(1)    NOT NULL,
  SC_COL_FILTERS  CHARACTER(1)    NOT NULL,
  SC_COL_JOBID    INTEGER         NOT NULL,
  SC_COL_NODENUM  INTEGER         NOT NULL,
  SC_COL_EVMVER   INTEGER         NOT NULL,
  SC_COL_DB2VER   CHARACTER(8)    NOT NULL,
  SC_COL_SCAVER   CHARACTER(8)    NOT NULL,
  SC_COL_SCCVER   CHARACTER(8)    NOT NULL  DEFAULT '02.01.00'
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 70;

ALTER TABLE QUEST.SC_COLLECTION
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 80;

CREATE TABLE QUEST.SC_COLUMNS
 (SC_COL_HOSTID  INTEGER         NOT NULL,
  SC_COL_TABID   INTEGER         NOT NULL,
  SC_COL_ID      INTEGER         NOT NULL,
  SC_COL_TIME    TIMESTAMP       NOT NULL,
  SC_COL_NAME    VARCHAR(128)    NOT NULL,
  SC_COL_STATUS  CHARACTER(1)    NOT NULL,
  SC_COL_TYPE    VARCHAR(18)     NOT NULL,
  SC_COL_SCALE   INTEGER         NOT NULL,
  SC_COL_LENGTH  INTEGER         NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 90;

ALTER TABLE QUEST.SC_COLUMNS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 100;

CREATE TABLE QUEST.SC_CONNECTIONS
 (SC_CONNS_CKEY       INTEGER         NOT NULL,
  SC_CONNS_SUBCKEY    INTEGER         NOT NULL DEFAULT 0,

  SC_CONNS_COKEY      INTEGER         NOT NULL,

  SC_CONNS_APP        CHARACTER(60)   NOT NULL,

  SC_CONNS_APPLID     CHARACTER(32)   NOT NULL,

  SC_CONNS_USERID     CHARACTER(30)   NOT NULL,

  SC_CONNS_AUTHID     CHARACTER(30)   NOT NULL,

  SC_CONNS_AGENTID    INTEGER         NOT NULL,

  SC_CONNS_UCPU       CHARACTER(19)   NOT NULL,

  SC_CONNS_SCPU       CHARACTER(19)   NOT NULL,

  SC_CONNS_STIME      TIMESTAMP       NOT NULL,

  SC_CONNS_ETIME      TIMESTAMP       NOT NULL,

  SC_CONNS_ROWR       BIGINT          NOT NULL,

  SC_CONNS_ROWW       BIGINT          NOT NULL,

  SC_CONNS_ROWRW      BIGINT          NOT NULL,

  SC_CONNS_BDATLREAD  BIGINT          NOT NULL,

  SC_CONNS_BDATPREAD  BIGINT          NOT NULL,

  SC_CONNS_BDATWRITE  BIGINT          NOT NULL,

  SC_CONNS_BPDAT2E    BIGINT          NOT NULL,

  SC_CONNS_BPDATFE    BIGINT          NOT NULL,

  SC_CONNS_BIDXLREAD  BIGINT          NOT NULL,

  SC_CONNS_BIDXPREAD  BIGINT          NOT NULL,

  SC_CONNS_BIDXWRITE  BIGINT          NOT NULL,

  SC_CONNS_BPIDX2E    BIGINT          NOT NULL,

  SC_CONNS_BPIDXFE    BIGINT          NOT NULL,

  SC_CONNS_DIRRREQ    BIGINT          NOT NULL,

  SC_CONNS_DIRWREQ    BIGINT          NOT NULL,

  SC_CONNS_UREADPP    BIGINT          NOT NULL,

  SC_CONNS_BPRTIME    BIGINT          NOT NULL,

  SC_CONNS_BPWTIME    BIGINT          NOT NULL,

  SC_CONNS_DIRREAD    BIGINT          NOT NULL,

  SC_CONNS_DIRWRITE   BIGINT          NOT NULL,

  SC_CONNS_DREADTIM   BIGINT          NOT NULL,

  SC_CONNS_DWRITETIM  BIGINT          NOT NULL,

  SC_CONNS_LOCKWAIT   BIGINT         NOT NULL,

  SC_CONNS_LOCKTIME   BIGINT         NOT NULL,

  SC_CONNS_LOCKESC    BIGINT         NOT NULL,

  SC_CONNS_XLOCKESC   BIGINT         NOT NULL,

  SC_CONNS_DEADLOCKS  BIGINT         NOT NULL,

  SC_CONNS_LCKTIMOUT  BIGINT         NOT NULL,

  SC_CONNS_SORTS      BIGINT         NOT NULL,

  SC_CONNS_SORTTIME   BIGINT         NOT NULL,

  SC_CONNS_SORTOVER   BIGINT         NOT NULL,

  SC_CONNS_COMATPD    BIGINT         NOT NULL,

  SC_CONNS_ROLATPD    BIGINT         NOT NULL,

  SC_CONNS_DSQLATPD   BIGINT         NOT NULL,

  SC_CONNS_SSQLATPD   BIGINT         NOT NULL,

  SC_CONNS_DDLATPD    BIGINT         NOT NULL,

  SC_CONNS_UIDATPD    BIGINT         NOT NULL,

  SC_CONNS_IAUTORBND  BIGINT         NOT NULL,

  SC_CONNS_IROWDEL    BIGINT         NOT NULL,

  SC_CONNS_IROWUPD    BIGINT         NOT NULL,

  SC_CONNS_IROWINS    BIGINT         NOT NULL,

  SC_CONNS_INTCOM     BIGINT         NOT NULL,

  SC_CONNS_INTROL     BIGINT         NOT NULL,

  SC_CONNS_INTROLDL   BIGINT         NOT NULL,

  SC_CONNS_ROWSDEL    BIGINT         NOT NULL,

  SC_CONNS_ROWSINS    BIGINT         NOT NULL,

  SC_CONNS_ROWSUPD    BIGINT         NOT NULL,

  SC_CONNS_IROWSEL    BIGINT         NOT NULL,
  SC_CONNS_BNDSATPD   BIGINT         NOT NULL,
  SC_CONNS_REJCURRQ   BIGINT         NOT NULL,
  SC_CONNS_FAILSQL    BIGINT         NOT NULL,
  SC_CONNS_SELSQL     BIGINT         NOT NULL,
  SC_CONNS_PFWTIME    BIGINT         NOT NULL,
  SC_CONNS_SECINS     BIGINT         NOT NULL,
  SC_CONNS_SECLUPS    BIGINT         NOT NULL,
  SC_CONNS_THASHJ     BIGINT         NOT NULL,
  SC_CONNS_THASHL     BIGINT         NOT NULL,
  SC_CONNS_THASHO     BIGINT         NOT NULL,
  SC_CONNS_THASHSO    BIGINT         NOT NULL,
  SC_CONNS_ACCCURRQ   BIGINT         NOT NULL,
  SC_CONNS_PKGCALKS   BIGINT         NOT NULL,
  SC_CONNS_PKGCAINS   BIGINT         NOT NULL,
  SC_CONNS_CATCAINS   BIGINT         NOT NULL,
  SC_CONNS_CATCALUP   BIGINT         NOT NULL,
  SC_CONNS_CATCAOVF   BIGINT         NOT NULL,
  SC_CONNS_CATCAHFL   BIGINT         NOT NULL,
  SC_CONNS_CATCASIZETOP  BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_PWSSIZETOP    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_PWSOVF        BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_PWSSECTINS    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_PWSSECTLUP    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_SWSSIZETOP    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_SWSOVF        BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_SWSSECTINS    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_SWSSECTLUP    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_BTMPDLREAD    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_BTMPDPREAD    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_BTMPILREAD    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_BTMPIPREAD    BIGINT      NOT NULL  DEFAULT 0,
  SC_CONNS_NODENUM    INTEGER         NOT NULL,
  SC_CONNS_CORDNODE   INTEGER         NOT NULL,
  SC_CONNS_ELAPSD     CHARACTER(19)   NOT NULL,
  SC_CONNS_TOTCPU     CHARACTER(19)   NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 110;

ALTER TABLE QUEST.SC_CONNECTIONS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 120;

CREATE TABLE QUEST.SC_DEADLOCKS
 (SC_DL_CKEY       INTEGER         NOT NULL,
  SC_DL_SUBCKEY    INTEGER         NOT NULL  DEFAULT 0,
  SC_DL_STIME      TIMESTAMP       NOT NULL,
  SC_DL_DLID       INTEGER         NOT NULL  DEFAULT 0,
  SC_DL_DLNODE     INTEGER         NOT NULL  DEFAULT -1,
  SC_DL_EVMACTS    BIGINT          NOT NULL  DEFAULT 0,
  SC_DL_CONNS      INTEGER         NOT NULL,
  SC_DL_RBAGENTID  INTEGER         NOT NULL,
  SC_DL_RBPARTNO   INTEGER         NOT NULL  DEFAULT 0,
  SC_DL_RBAPPID    CHARACTER(32)   NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 130;

ALTER TABLE QUEST.SC_DEADLOCKS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 140;

CREATE TABLE QUEST.SC_DLDETAIL
 (SC_DLDET_CKEY       INTEGER                      NOT NULL,
  SC_DLDET_SUBCKEY    INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_DLKEY      INTEGER                      NOT NULL,
  SC_DLDET_STIME      TIMESTAMP                    NOT NULL,
  SC_DLDET_DLID       INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_DLNODE     INTEGER                      NOT NULL  DEFAULT -1,
  SC_DLDET_EVMACTS    BIGINT                       NOT NULL  DEFAULT 0,
  SC_DLDET_LMODE      INTEGER                      NOT NULL,
  SC_DLDET_LOTYPE     INTEGER                      NOT NULL,
  SC_DLDET_LONAME     INTEGER                      NOT NULL,
  SC_DLDET_LNODE      INTEGER                      NOT NULL,
  SC_DLDET_AGENTID    INTEGER                      NOT NULL,
  SC_DLDET_LMREQTD    INTEGER                      NOT NULL,
  SC_DLDET_PARTNO     INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_PARTNOHLK  INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_LKATTRS    INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_LKRELFLGS  INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_LKCNT      INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_LKHLDCNT   INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_LKCMODE    INTEGER                      NOT NULL  DEFAULT 0,
  SC_DLDET_LKNAME     VARCHAR(32) FOR BIT DATA     NOT NULL  DEFAULT '',
  SC_DLDET_TNAME      CHARACTER(128)               NOT NULL,
  SC_DLDET_TSCHEMA    CHARACTER(128)               NOT NULL,
  SC_DLDET_LESCAL     INTEGER                      NOT NULL,
  SC_DLDET_APPIDHL    CHARACTER(32)                NOT NULL,
  SC_DLDET_APPID      CHARACTER(32)                NOT NULL,
  SC_DLDET_TSNAME     CHARACTER(18)                NOT NULL,
  SC_DLDET_LWSTIME    TIMESTAMP                    NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 150;

ALTER TABLE QUEST.SC_DLDETAIL
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;
  
#SYNC 160;

CREATE TABLE QUEST.SC_EXPLAIN_DATA
 (SC_EXPDAT_CKEY     INTEGER                      NOT NULL,
  SC_EXPDAT_SUBCKEY  INTEGER                      NOT NULL,
  SC_EXPDAT_PKEY     CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_EXPDAT_STKEY    BIGINT                       NOT NULL,
  SC_EXPDAT_SEQNO    INTEGER                      NOT NULL,
  SC_EXPDAT_TIME     TIMESTAMP                    NOT NULL,
  SC_EXPDAT_DATA     VARCHAR(254) FOR BIT DATA    NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 170;

ALTER TABLE QUEST.SC_EXPLAIN_DATA
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 180;

CREATE TABLE QUEST.SC_EXPLAIN_SUMM
 (SC_EXPSUM_CKEY     INTEGER                      NOT NULL,
  SC_EXPSUM_SUBCKEY  INTEGER                      NOT NULL,
  SC_EXPSUM_PKEY     CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_EXPSUM_STKEY    BIGINT                       NOT NULL,
  SC_EXPSUM_TIME     TIMESTAMP                    NOT NULL,
  SC_EXPSUM_HOSTID   INTEGER                      NOT NULL,
  SC_EXPSUM_STEPS    SMALLINT                     NOT NULL,
  SC_EXPSUM_TBSCANS  SMALLINT                     NOT NULL,
  SC_EXPSUM_IXMSCANS SMALLINT                     NOT NULL,
  SC_EXPSUM_IXNSCANS SMALLINT                     NOT NULL,
  SC_EXPSUM_SORTS    SMALLINT                     NOT NULL,
  SC_EXPSUM_IXAND    SMALLINT                     NOT NULL,
  SC_EXPSUM_IXOR     SMALLINT                     NOT NULL,
  SC_EXPSUM_NLJOIN   SMALLINT                     NOT NULL,
  SC_EXPSUM_MSJOIN   SMALLINT                     NOT NULL,
  SC_EXPSUM_HJOIN    SMALLINT                     NOT NULL,
  SC_EXPSUM_SPFTCH   SMALLINT                     NOT NULL,
  SC_EXPSUM_LPFTCH   SMALLINT                     NOT NULL,
  SC_EXPSUM_XLROW    SMALLINT                     NOT NULL,
  SC_EXPSUM_IXLROW   SMALLINT                     NOT NULL,
  SC_EXPSUM_ISLROW   SMALLINT                     NOT NULL,
  SC_EXPSUM_INLROW   SMALLINT                     NOT NULL,
  SC_EXPSUM_NKSLROW  SMALLINT                     NOT NULL,
  SC_EXPSUM_RLROW    SMALLINT                     NOT NULL,
  SC_EXPSUM_SLROW    SMALLINT                     NOT NULL,
  SC_EXPSUM_SSLROW   SMALLINT                     NOT NULL,
  SC_EXPSUM_SXLROW   SMALLINT                     NOT NULL,
  SC_EXPSUM_ULROW    SMALLINT                     NOT NULL,
  SC_EXPSUM_XLTAB    SMALLINT                     NOT NULL,
  SC_EXPSUM_IXLTAB   SMALLINT                     NOT NULL,
  SC_EXPSUM_ISLTAB   SMALLINT                     NOT NULL,
  SC_EXPSUM_INLTAB   SMALLINT                     NOT NULL,
  SC_EXPSUM_RTBSCANS SMALLINT                     NOT NULL,
  SC_EXPSUM_RLTAB    SMALLINT                     NOT NULL,
  SC_EXPSUM_SLTAB    SMALLINT                     NOT NULL,
  SC_EXPSUM_SIXLTAB  SMALLINT                     NOT NULL,
  SC_EXPSUM_SXLTAB   SMALLINT                     NOT NULL,
  SC_EXPSUM_ULTAB    SMALLINT                     NOT NULL,
  SC_EXPSUM_IXSCANS  SMALLINT                     NOT NULL,
  SC_EXPSUM_TOTCOST  DOUBLE                       NOT NULL,
  SC_EXPSUM_SQLCODE  INTEGER                      NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 190;

ALTER TABLE QUEST.SC_EXPLAIN_SUMM
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 200;

CREATE TABLE QUEST.SC_HOSTIDS
 (SC_HOST_ID      INTEGER         NOT NULL,
  SC_HOST_DBNAME  CHARACTER(18)   NOT NULL,
  SC_HOST_MACHNE  VARCHAR(255)    NOT NULL,
  SC_HOST_INSTAN  CHARACTER(8)    NOT NULL,
  SC_HOST_TIME    TIMESTAMP,
  SC_HOST_STATUS  CHARACTER(1)    NOT NULL,
  SC_HOST_JOBID   INTEGER         NOT NULL  DEFAULT 0,
  SC_HOST_SJOBID  INTEGER         NOT NULL  DEFAULT 0
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 210;

ALTER TABLE QUEST.SC_HOSTIDS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 220;

CREATE TABLE QUEST.SC_IDXDEP
 (SC_IDXDEP_CKEY     INTEGER                      NOT NULL,
  SC_IDXDEP_SUBCKEY  INTEGER                      NOT NULL,
  SC_IDXDEP_PKEY     CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_IDXDEP_STKEY    BIGINT                       NOT NULL,
  SC_IDXDEP_TIME     TIMESTAMP                    NOT NULL,
  SC_IDXDEP_SEQNO    SMALLINT                     NOT NULL,
  SC_IDXDEP_TABID    INTEGER                      NOT NULL,
  SC_IDXDEP_HOSTID   INTEGER                      NOT NULL,
  SC_IDXDEP_IDXID    INTEGER                      NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 230;

ALTER TABLE QUEST.SC_IDXDEP
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 240;

CREATE TABLE QUEST.SC_INDEXES
 (SC_IDX_HOSTID  INTEGER         NOT NULL,
  SC_IDX_ID      INTEGER         NOT NULL,
  SC_IDX_TABID   INTEGER         NOT NULL,
  SC_IDX_TIME    TIMESTAMP       NOT NULL,
  SC_IDX_SCHEMA  VARCHAR(128)    NOT NULL,
  SC_IDX_NAME    VARCHAR(128)    NOT NULL,
  SC_IDX_STATUS  CHARACTER(1)    NOT NULL,
  SC_IDX_TYPE    CHARACTER(1)    NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 250;
  
ALTER TABLE QUEST.SC_INDEXES
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 260;

CREATE TABLE QUEST.SC_LITERALS
 (SC_LITS_CKEY     INTEGER         NOT NULL,
  SC_LITS_SUBCKEY  INTEGER         NOT NULL  DEFAULT 0,
  SC_LITS_STKEY    BIGINT          NOT NULL,
  SC_LITS_SEQNO    INTEGER         NOT NULL,
  SC_LITS_DATA     VARCHAR(254)    NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 270;

ALTER TABLE QUEST.SC_LITERALS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 280;

CREATE TABLE QUEST.SC_PATTERNS
 (SC_PTRN_PKEY     CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_PTRN_CKEY     INTEGER                      NOT NULL,
  SC_PTRN_SUBCKEY  INTEGER                      NOT NULL  DEFAULT 0,
  SC_PTRN_FREQ     INTEGER                      NOT NULL,
  SC_PTRN_FREQ2    INTEGER                      NOT NULL  DEFAULT 0,
  SC_PTRN_TIME     TIMESTAMP                    NOT NULL,
  SC_PTRN_STKEY    BIGINT                       NOT NULL  DEFAULT 0,
  SC_PTRN_TYPE     CHARACTER(1)                 NOT NULL,
  SC_PTRN_UNION    CHARACTER(1)                 NOT NULL,
  SC_PTRN_EXCPT    CHARACTER(1)                 NOT NULL,
  SC_PTRN_INTER    CHARACTER(1)                 NOT NULL,
  SC_PTRN_WHERE    CHARACTER(1)                 NOT NULL,
  SC_PTRN_ORDER    CHARACTER(1)                 NOT NULL,
  SC_PTRN_GROUP    CHARACTER(1)                 NOT NULL,
  SC_PTRN_HAVING   CHARACTER(1)                 NOT NULL,
  SC_PTRN_CASE     CHARACTER(1)                 NOT NULL,
  SC_PTRN_PBASIC   CHARACTER(1)                 NOT NULL,
  SC_PTRN_PBETWN   CHARACTER(1)                 NOT NULL,
  SC_PTRN_PEXIST   CHARACTER(1)                 NOT NULL,
  SC_PTRN_PLIKE    CHARACTER(1)                 NOT NULL,
  SC_PTRN_PIN      CHARACTER(1)                 NOT NULL,
  SC_PTRN_PQUANT   CHARACTER(1)                 NOT NULL,
  SC_PTRN_PNULL    CHARACTER(1)                 NOT NULL,
  SC_PTRN_PTYPED   CHARACTER(1)                 NOT NULL,
  SC_PTRN_SINTO    CHARACTER(1)                 NOT NULL,
  SC_PTRN_FETONLY  CHARACTER(1)                 NOT NULL,
  SC_PTRN_FUPDT    CHARACTER(1)                 NOT NULL,
  SC_PTRN_OPTFOR   CHARACTER(1)                 NOT NULL,
  SC_PTRN_CTE      CHARACTER(1)                 NOT NULL,
  SC_PTRN_WITH     CHARACTER(1)                 NOT NULL,
  SC_PTRN_QUERYNO  CHARACTER(1)                 NOT NULL,
  SC_PTRN_JOINS    CHARACTER(1)                 NOT NULL,
  SC_PTRN_INVIEW   CHARACTER(1)                 NOT NULL,
  SC_PTRN_CFUNC    CHARACTER(1)                 NOT NULL,
  SC_PTRN_SFUNC    CHARACTER(1)                 NOT NULL,
  SC_PTRN_RFUNC    CHARACTER(1)                 NOT NULL,
  SC_PTRN_UFUNC    CHARACTER(1)                 NOT NULL,
  SC_PTRN_TFUNC    CHARACTER(1)                 NOT NULL,
  SC_PTRN_TEXT     CHARACTER(50)                NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 290;

ALTER TABLE QUEST.SC_PATTERNS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 300;

CREATE TABLE QUEST.SC_QUERIES
 (SC_QUERY_TYPE     INTEGER         NOT NULL,
  SC_QUERY_NAME     CHARACTER(32)   NOT NULL,
  SC_QUERY_ID       INTEGER         NOT NULL,
  SC_QUERY_SCOPE    CHARACTER(1)    NOT NULL,
  SC_QUERY_CVER     CHARACTER(8)    NOT NULL,
  SC_QUERY_AVER     CHARACTER(8)    NOT NULL,
  SC_QUERY_DBVER    CHARACTER(5)    NOT NULL,
  SC_QUERY_LTIME    TIMESTAMP,
  SC_QUERY_USER     VARCHAR(254),    
  SC_QUERY_DESC     VARCHAR(254)
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 310;

ALTER TABLE QUEST.SC_QUERIES
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 320;

CREATE TABLE QUEST.SC_QUERY_DATA
 (SC_QRYDAT_ID      INTEGER                      NOT NULL,
  SC_QRYDAT_TYPE    INTEGER                      NOT NULL,
  SC_QRYDAT_STMTNO  SMALLINT                     NOT NULL,
  SC_QRYDAT_SEQNO   INTEGER                      NOT NULL,
  SC_QRYDAT_DATA    VARCHAR(254) FOR BIT DATA    NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 330;

ALTER TABLE QUEST.SC_QUERY_DATA
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 340;

CREATE TABLE QUEST.SC_STATISTICS
 (SC_STATS_CKEY    INTEGER                      NOT NULL,
  SC_STATS_SUBCKEY INTEGER                      NOT NULL DEFAULT 0,
  SC_STATS_STKEY   BIGINT                       NOT NULL,
  SC_STATS_STIME   TIMESTAMP                    NOT NULL,
  SC_STATS_ETIME   TIMESTAMP                    NOT NULL,
  SC_STATS_PKEY    CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_STATS_APP     CHARACTER(60)                NOT NULL,
  SC_STATS_APPLID  CHARACTER(32)                NOT NULL,
  SC_STATS_AGENTID INTEGER                      NOT NULL,
  SC_STATS_PROG    CHARACTER(8)                 NOT NULL,
  SC_STATS_USER    CHARACTER(30)                NOT NULL,
  SC_STATS_AUTHID  CHARACTER(30)                NOT NULL,
  SC_STATS_UCPU    CHARACTER(15)                NOT NULL,
  SC_STATS_SCPU    CHARACTER(15)                NOT NULL,
  SC_STATS_FTCHS   BIGINT                       NOT NULL,
  SC_STATS_SORTS   BIGINT                       NOT NULL,
  SC_STATS_SRTIME  BIGINT                       NOT NULL,
  SC_STATS_SOVR    BIGINT                       NOT NULL,
  SC_STATS_ROWR    BIGINT                       NOT NULL,
  SC_STATS_ROWW    BIGINT                       NOT NULL,
  SC_STATS_ROWRW   BIGINT                       NOT NULL,
  SC_STATS_IRD     BIGINT                       NOT NULL,
  SC_STATS_IRU     BIGINT                       NOT NULL,
  SC_STATS_IRI     BIGINT                       NOT NULL,
  SC_STATS_PUPD    BIGINT                       NOT NULL,
  SC_STATS_PDEL    BIGINT                       NOT NULL,
  SC_STATS_AGENTS  INTEGER                      NOT NULL,
  SC_STATS_SECNUM  INTEGER                      NOT NULL DEFAULT 0,
  SC_STATS_SQLCODE INTEGER                      NOT NULL,
  SC_STATS_PREPELTMS   BIGINT                   NOT NULL DEFAULT 0,
  SC_STATS_PREPCPUTMS  BIGINT                   NOT NULL DEFAULT 0,
  SC_STATS_BDATLREAD   BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BDATPREAD   BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BIDXLREAD   BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BIDXPREAD   BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BTMPDLREAD  BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BTMPDPREAD  BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BTMPILREAD  BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_BTMPIPREAD  BIGINT                   NOT NULL  DEFAULT 0,
  SC_STATS_STYPE   CHARACTER(1)                 NOT NULL,
  SC_STATS_ELAPSD  CHARACTER(15)                NOT NULL,
  SC_STATS_TOTCPU  CHARACTER(15)                NOT NULL,
  SC_STATS_OPFLAGS CHARACTER(4) FOR BIT DATA    NOT NULL,
  SC_STATS_CURSOR  VARCHAR(18)                  NOT NULL DEFAULT '',
  SC_STATS_VERID   VARCHAR(64)                  NOT NULL DEFAULT '',
  SC_STATS_CONTOK  CHARACTER(8) FOR BIT DATA    NOT NULL DEFAULT '',
  SC_STATS_BLKCUR  CHARACTER(1)                 NOT NULL DEFAULT '',
  SC_STATS_CREATOR VARCHAR(128)                 NOT NULL DEFAULT ''
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 350;

ALTER TABLE QUEST.SC_STATISTICS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 360;

CREATE TABLE QUEST.SC_STMT_TEXT
 (SC_PTEXT_PKEY  CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_PTEXT_SEQNO INTEGER                      NOT NULL,
  SC_PTEXT_DATA  VARCHAR(254)                 NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 370;

ALTER TABLE QUEST.SC_STMT_TEXT
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 380;

CREATE TABLE QUEST.SC_SUMMARY
 (SC_SUMM_CKEY    INTEGER         NOT NULL,
  SC_SUMM_SUBCKEY INTEGER         NOT NULL DEFAULT 0,
  SC_SUMM_RECTYP  INTEGER         NOT NULL,
  SC_SUMM_SEQNO   INTEGER         NOT NULL,
  SC_SUMM_RECID   CHARACTER(60)   NOT NULL,
  SC_SUMM_UCPU    CHARACTER(19)   NOT NULL,
  SC_SUMM_SCPU    CHARACTER(19)   NOT NULL,
  SC_SUMM_FTCHS   DOUBLE          NOT NULL,
  SC_SUMM_SORTS   DOUBLE          NOT NULL,
  SC_SUMM_SRTIME  DOUBLE          NOT NULL,
  SC_SUMM_SOVR    DOUBLE          NOT NULL,
  SC_SUMM_ROWR    DOUBLE          NOT NULL,
  SC_SUMM_ROWW    DOUBLE          NOT NULL,
  SC_SUMM_IRD     DOUBLE          NOT NULL,
  SC_SUMM_IRU     DOUBLE          NOT NULL,
  SC_SUMM_IRI     DOUBLE          NOT NULL,
  SC_SUMM_PUPD    DOUBLE          NOT NULL,
  SC_SUMM_PDEL    DOUBLE          NOT NULL,
  SC_SUMM_LOGU    DOUBLE          NOT NULL,
  SC_SUMM_LWAT    DOUBLE          NOT NULL,
  SC_SUMM_MLCK    DOUBLE          NOT NULL,
  SC_SUMM_LESC    DOUBLE          NOT NULL,
  SC_SUMM_XLESC   DOUBLE          NOT NULL,
  SC_SUMM_ROLLS   DOUBLE          NOT NULL,
  SC_SUMM_COMTS   DOUBLE          NOT NULL,
  SC_SUMM_STMTS   DOUBLE          NOT NULL,
  SC_SUMM_SELS    DOUBLE          NOT NULL,
  SC_SUMM_UPDS    DOUBLE          NOT NULL,
  SC_SUMM_DELS    DOUBLE          NOT NULL,
  SC_SUMM_INSTS   DOUBLE          NOT NULL,
  SC_SUMM_CONNS   DOUBLE          NOT NULL,
  SC_SUMM_TRANS   DOUBLE          NOT NULL,
  SC_SUMM_BDATLREAD   DOUBLE		 NOT NULL  DEFAULT 0.0,
  SC_SUMM_BDATPREAD   DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_BIDXLREAD   DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_BIDXPREAD   DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_BTMPDLREAD  DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_BTMPDPREAD  DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_BTMPILREAD  DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_BTMPIPREAD  DOUBLE      NOT NULL  DEFAULT 0.0,
  SC_SUMM_ELAPSD  CHARACTER(19)   NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 390;

ALTER TABLE QUEST.SC_SUMMARY
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 400;

CREATE TABLE QUEST.SC_TABDEP
 (SC_TABDEP_HOSTID  INTEGER                      NOT NULL,
  SC_TABDEP_TABID   INTEGER                      NOT NULL,
  SC_TABDEP_PTRN    CHARACTER(32) FOR BIT DATA   NOT NULL,
  SC_TABDEP_SEQNO   INTEGER                      NOT NULL,
  SC_TABDEP_SPOS    SMALLINT                     NOT NULL,
  SC_TABDEP_USE1    SMALLINT                     NOT NULL,
  SC_TABDEP_USE2    SMALLINT                     NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 410;

ALTER TABLE QUEST.SC_TABDEP
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 420;

CREATE TABLE QUEST.SC_TABLES
 (SC_TAB_HOSTID  INTEGER         NOT NULL,
  SC_TAB_ID      INTEGER         NOT NULL,
  SC_TAB_TIME    TIMESTAMP       NOT NULL,
  SC_TAB_SCHEMA  VARCHAR(128)    NOT NULL,
  SC_TAB_NAME    VARCHAR(128)    NOT NULL,
  SC_TAB_STATUS  CHARACTER(1)    NOT NULL,
  SC_TAB_TYPE    CHARACTER(1)    NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 430;

ALTER TABLE QUEST.SC_TABLES
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 440;

CREATE TABLE QUEST.SC_TRANSACTIONS
 (SC_TRANS_CKEY     INTEGER         NOT NULL,
  SC_TRANS_SUBCKEY  INTEGER         NOT NULL  DEFAULT 0,
  SC_TRANS_TRKEY    BIGINT          NOT NULL,
  SC_TRANS_STIME    TIMESTAMP       NOT NULL,
  SC_TRANS_ETIME    TIMESTAMP       NOT NULL,
  SC_TRANS_APP      CHARACTER(60)   NOT NULL,
  SC_TRANS_APPLID   CHARACTER(32)   NOT NULL,
  SC_TRANS_USERID   CHARACTER(30)   NOT NULL,
  SC_TRANS_AUTHID   CHARACTER(30)   NOT NULL,
  SC_TRANS_AGENTID  INTEGER         NOT NULL,
  SC_TRANS_UCPU     CHARACTER(15)   NOT NULL,
  SC_TRANS_SCPU     CHARACTER(15)   NOT NULL,
  SC_TRANS_LOGUSE   BIGINT          NOT NULL,
  SC_TRANS_LOCKWAIT BIGINT          NOT NULL,
  SC_TRANS_MLOCKH   BIGINT          NOT NULL,
  SC_TRANS_LOCKESC  BIGINT          NOT NULL,
  SC_TRANS_XLOCKESC BIGINT          NOT NULL,
  SC_TRANS_ROWR     BIGINT          NOT NULL,
  SC_TRANS_ROWW     BIGINT          NOT NULL,
  SC_TRANS_ROWRW    BIGINT          NOT NULL,
  SC_TRANS_STATUS   CHARACTER(1)    NOT NULL,
  SC_TRANS_ELAPSD   CHARACTER(15)   NOT NULL,
  SC_TRANS_TOTCPU   CHARACTER(15)   NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 450;

ALTER TABLE QUEST.SC_TRANSACTIONS
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 460;

CREATE TABLE QUEST.SC_VIEWDEP
 (SC_VIEWDEP_HOSTID  INTEGER         NOT NULL,
  SC_VIEWDEP_TABID   INTEGER         NOT NULL,
  SC_VIEWDEP_BTABID  INTEGER         NOT NULL,
  SC_VIEWDEP_TIME    TIMESTAMP       NOT NULL,
  SC_VIEWDEP_STATUS  CHARACTER(1)    NOT NULL
 )
  DATA CAPTURE NONE
  IN USERSPACE1;

#SYNC 470;

ALTER TABLE QUEST.SC_VIEWDEP
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 480;

CREATE TABLE QUEST.SC_WORKLOAD
 (SC_WLOAD_CKEY          INTEGER         NOT NULL,
  SC_WLOAD_SUBCKEY       INTEGER         NOT NULL  DEFAULT 0,
  SC_WLOAD_TYPE          INTEGER         NOT NULL  DEFAULT 0,
  SC_WLOAD_SEQNO         INTEGER         NOT NULL,
  SC_WLOAD_INTERVAL      INTEGER         NOT NULL,
  SC_WLOAD_TRANS         DOUBLE          NOT NULL,
  SC_WLOAD_STATEMENTS    DOUBLE          NOT NULL,
  SC_WLOAD_SELECTS       DOUBLE          NOT NULL,
  SC_WLOAD_UPDATES       DOUBLE          NOT NULL,
  SC_WLOAD_DELETES       DOUBLE          NOT NULL,
  SC_WLOAD_INSERTS       DOUBLE          NOT NULL,
  SC_WLOAD_COMMITS       DOUBLE          NOT NULL,
  SC_WLOAD_ROLLBACKS     DOUBLE          NOT NULL,
  SC_WLOAD_DEADLOCKS     DOUBLE          NOT NULL,
  SC_WLOAD_TIMEOUTS      DOUBLE          NOT NULL,
  SC_WLOAD_ABENDS        DOUBLE          NOT NULL,
  SC_WLOAD_OTHERS        DOUBLE          NOT NULL,
  SC_WLOAD_MAXLOCK       DOUBLE          NOT NULL,
  SC_WLOAD_LOCKESC       DOUBLE          NOT NULL,
  SC_WLOAD_XLOCKESC      DOUBLE          NOT NULL,
  SC_WLOAD_SORTS         DOUBLE          NOT NULL,
  SC_WLOAD_SORTOVRS      DOUBLE          NOT NULL,
  SC_WLOAD_IROWDEL       DOUBLE          NOT NULL,
  SC_WLOAD_IROWUPD       DOUBLE          NOT NULL,
  SC_WLOAD_IROWINS       DOUBLE          NOT NULL,
  SC_WLOAD_FETCHES       DOUBLE          NOT NULL,
  SC_WLOAD_ROWSREAD      DOUBLE          NOT NULL,
  SC_WLOAD_ROWSWRITTEN   DOUBLE          NOT NULL,
  SC_WLOAD_BDATLREAD		DOUBLE          NOT NULL,
  SC_WLOAD_BDATPREAD		DOUBLE          NOT NULL,
  SC_WLOAD_BIDXLREAD		DOUBLE          NOT NULL,
  SC_WLOAD_BIDXPREAD		DOUBLE          NOT NULL,
  SC_WLOAD_BTMPDLREAD	DOUBLE          NOT NULL,
  SC_WLOAD_BTMPDPREAD	DOUBLE          NOT NULL,
  SC_WLOAD_BTMPILREAD	DOUBLE          NOT NULL,
  SC_WLOAD_BTMPIPREAD	DOUBLE          NOT NULL,
  SC_WLOAD_UCPU          CHARACTER(19)   NOT NULL,
  SC_WLOAD_SCPU          CHARACTER(19)   NOT NULL,
  SC_WLOAD_ELAPSED       CHARACTER(19)   NOT NULL,
  SC_WLOAD_SORTTIME      CHARACTER(19)   NOT NULL,
  SC_WLOAD_LOCKWAITTIME  CHARACTER(19)   NOT NULL,
  SC_WLOAD_TRANSELAPSED  CHARACTER(19)   NOT NULL,
  SC_WLOAD_STARTTIME     TIMESTAMP       NOT NULL,
  SC_WLOAD_ENDTIME       TIMESTAMP       NOT NULL
 )
  DATA CAPTURE NONE
  IN @SCREPO_DATA_TS 
  INDEX IN @SCREPO_INDEX_TS;

#SYNC 490;

ALTER TABLE QUEST.SC_WORKLOAD
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 500;

-- CREATE SQL ANALYSIS REPOSITORY INDEXES.
CREATE UNIQUE INDEX QUEST.SC_PATS_CK
  ON QUEST.SC_PATTERNS
 (SC_PTRN_PKEY      ASC,
  SC_PTRN_CKEY      ASC,
  SC_PTRN_SUBCKEY   ASC,
  SC_PTRN_TYPE      ASC
 )
  CLUSTER
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 502;

CREATE UNIQUE INDEX QUEST.SC_STATS_CK
  ON QUEST.SC_STATISTICS
 (SC_STATS_CKEY      ASC,
  SC_STATS_SUBCKEY   ASC,
  SC_STATS_ETIME     ASC,
  SC_STATS_STKEY     ASC
 )
  CLUSTER
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 505;

CREATE INDEX QUEST.SC_STATS_IX1
  ON QUEST.SC_STATISTICS
 (SC_STATS_CKEY      ASC,
  SC_STATS_SUBCKEY   ASC,
  SC_STATS_APPLID    ASC,
  SC_STATS_AGENTID   ASC
 )
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 510;

CREATE UNIQUE INDEX QUEST.SC_TRANS_CK
  ON QUEST.SC_TRANSACTIONS
 (SC_TRANS_CKEY      ASC,
  SC_TRANS_SUBCKEY   ASC,
  SC_TRANS_ETIME     ASC,
  SC_TRANS_TRKEY     ASC
 )
  CLUSTER
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 515;

CREATE INDEX QUEST.SC_TRANS_IX1
  ON QUEST.SC_TRANSACTIONS
 (SC_TRANS_CKEY      ASC,
  SC_TRANS_SUBCKEY   ASC,
  SC_TRANS_APPLID    ASC,
  SC_TRANS_AGENTID   ASC
 )
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 520;

ALTER TABLE QUEST.SC_COLDEP
  ADD CONSTRAINT SC_COLDEP_PK PRIMARY KEY
   (SC_COLDEP_HOSTID,
    SC_COLDEP_TABID,
    SC_COLDEP_COLID,
    SC_COLDEP_PTRN,
    SC_COLDEP_SEQNO
   );

#SYNC 530;

ALTER TABLE QUEST.SC_COLINFO
  ADD CONSTRAINT SC_COLINFO_PK PRIMARY KEY
   (SC_CINFO_CKEY,
    SC_CINFO_SUBCKEY,
    SC_CINFO_SEQNO
   );

#SYNC 540;

ALTER TABLE QUEST.SC_COLLECTION
  ADD CONSTRAINT SC_COLL_PK PRIMARY KEY
   (SC_COL_CKEY,
    SC_COL_SUBCKEY
   );

#SYNC 550;

ALTER TABLE QUEST.SC_COLUMNS
  ADD CONSTRAINT SC_COLUMNS_PK PRIMARY KEY
   (SC_COL_HOSTID,
    SC_COL_TABID,
    SC_COL_ID
   );

#SYNC 560;

ALTER TABLE QUEST.SC_CONNECTIONS
  ADD CONSTRAINT SC_CONN_PK PRIMARY KEY
   (SC_CONNS_CKEY,
    SC_CONNS_SUBCKEY,
    SC_CONNS_ETIME,
    SC_CONNS_COKEY
   );

#SYNC 570;

ALTER TABLE QUEST.SC_DEADLOCKS
  ADD CONSTRAINT SC_DEADLOCKS_PK PRIMARY KEY
   (SC_DL_CKEY,
    SC_DL_SUBCKEY,
    SC_DL_STIME,
    SC_DL_CONNS,
    SC_DL_DLID,
    SC_DL_DLNODE,
    SC_DL_EVMACTS
   );

#SYNC 580;

ALTER TABLE QUEST.SC_DLDETAIL
  ADD CONSTRAINT SC_DLDETAIL_PK PRIMARY KEY
   (SC_DLDET_CKEY,
    SC_DLDET_SUBCKEY,
    SC_DLDET_STIME,
    SC_DLDET_DLKEY,
    SC_DLDET_DLID,
    SC_DLDET_DLNODE,
    SC_DLDET_EVMACTS
   );

#SYNC 590;

ALTER TABLE QUEST.SC_EXPLAIN_DATA
  ADD CONSTRAINT SC_EXPDAT_PK PRIMARY KEY
   (SC_EXPDAT_CKEY,
    SC_EXPDAT_SUBCKEY,
    SC_EXPDAT_PKEY,
    SC_EXPDAT_STKEY,
    SC_EXPDAT_SEQNO,
    SC_EXPDAT_TIME
   );

#SYNC 600;

ALTER TABLE QUEST.SC_EXPLAIN_SUMM
  ADD CONSTRAINT SC_EXPSUM_PK PRIMARY KEY
   (SC_EXPSUM_CKEY,
    SC_EXPSUM_SUBCKEY,
    SC_EXPSUM_PKEY,
    SC_EXPSUM_STKEY,
    SC_EXPSUM_TIME
   );

#SYNC 610;

ALTER TABLE QUEST.SC_HOSTIDS
  ADD CONSTRAINT SC_HOSTIDS_PK PRIMARY KEY
   (SC_HOST_ID
   );

#SYNC 620;

ALTER TABLE QUEST.SC_IDXDEP
  ADD CONSTRAINT SC_IDXDEP_PK PRIMARY KEY
   (SC_IDXDEP_CKEY,
    SC_IDXDEP_SUBCKEY,
    SC_IDXDEP_PKEY,
    SC_IDXDEP_STKEY,
    SC_IDXDEP_TIME,
    SC_IDXDEP_SEQNO
   );

#SYNC 630;
   
ALTER TABLE QUEST.SC_INDEXES
  ADD CONSTRAINT SC_INDEX_PK PRIMARY KEY
   (SC_IDX_HOSTID,
    SC_IDX_ID,
    SC_IDX_TABID
   );

#SYNC 640;

ALTER TABLE QUEST.SC_LITERALS
  ADD CONSTRAINT SC_LITS_PK PRIMARY KEY
   (SC_LITS_CKEY,
    SC_LITS_SUBCKEY,
    SC_LITS_STKEY,
    SC_LITS_SEQNO
   );

#SYNC 650;

ALTER TABLE QUEST.SC_PATTERNS
  ADD CONSTRAINT SC_PATS_PK PRIMARY KEY
   (SC_PTRN_PKEY,
    SC_PTRN_CKEY,
    SC_PTRN_SUBCKEY,
    SC_PTRN_TYPE
   );

#SYNC 660;

ALTER TABLE QUEST.SC_QUERIES
  ADD CONSTRAINT SC_QUERIES_PK PRIMARY KEY
   (SC_QUERY_TYPE,
    SC_QUERY_NAME
   );

#SYNC 670;

ALTER TABLE QUEST.SC_QUERIES
  ADD CONSTRAINT SC_QUERIES_IDKEY UNIQUE
   (SC_QUERY_ID,
    SC_QUERY_TYPE
   );

#SYNC 680;

ALTER TABLE QUEST.SC_QUERY_DATA
  ADD CONSTRAINT SC_QRYDAT_PK PRIMARY KEY
   (SC_QRYDAT_ID,
    SC_QRYDAT_TYPE,
    SC_QRYDAT_STMTNO,
    SC_QRYDAT_SEQNO
   );

#SYNC 690;

ALTER TABLE QUEST.SC_STATISTICS
  ADD CONSTRAINT SC_STATS_PK PRIMARY KEY
   (SC_STATS_CKEY,
    SC_STATS_SUBCKEY,
    SC_STATS_ETIME,
    SC_STATS_STKEY
   );

#SYNC 700;

ALTER TABLE QUEST.SC_STMT_TEXT
  ADD CONSTRAINT SC_STEXT_PK PRIMARY KEY
   (SC_PTEXT_PKEY,
    SC_PTEXT_SEQNO
   );
   
#SYNC 710;

ALTER TABLE QUEST.SC_SUMMARY
  ADD CONSTRAINT SC_SUMM_PK PRIMARY KEY
   (SC_SUMM_CKEY,
    SC_SUMM_SUBCKEY,
    SC_SUMM_RECTYP,
    SC_SUMM_SEQNO
   );

#SYNC 720;

ALTER TABLE QUEST.SC_TABDEP
  ADD CONSTRAINT SC_TABDEP_PK PRIMARY KEY
   (SC_TABDEP_HOSTID,
    SC_TABDEP_TABID,
    SC_TABDEP_PTRN,
    SC_TABDEP_SEQNO
   );

#SYNC 730;

ALTER TABLE QUEST.SC_TABLES
  ADD CONSTRAINT SC_TABLE_PK PRIMARY KEY
   (SC_TAB_HOSTID,
    SC_TAB_ID
   );

#SYNC 740;

ALTER TABLE QUEST.SC_TRANSACTIONS
  ADD CONSTRAINT SC_TRANS_PK PRIMARY KEY
   (SC_TRANS_CKEY,
    SC_TRANS_SUBCKEY,
    SC_TRANS_ETIME,
    SC_TRANS_TRKEY
   );

#SYNC 750;

ALTER TABLE QUEST.SC_VIEWDEP
  ADD CONSTRAINT SC_VIEWDEP_PK PRIMARY KEY
   (SC_VIEWDEP_HOSTID,
    SC_VIEWDEP_TABID,
    SC_VIEWDEP_BTABID
   );

#SYNC 760;

ALTER TABLE QUEST.SC_WORKLOAD
  ADD CONSTRAINT SC_WORKLOAD_PK PRIMARY KEY
   (SC_WLOAD_CKEY,
    SC_WLOAD_SUBCKEY,
    SC_WLOAD_TYPE,
    SC_WLOAD_SEQNO
   );
   
#SYNC 770;